jQuery(document).ready(function($){
    const colors = {
        'eval':'red',
        'exec':'orange',
        'system':'yellow',
        'base64_decode':'blue',
        'Patrón avanzado detectado':'purple'
    };

    $('#wpss_scan').click(function(){
        $('#wpss_results').html('<p>Escaneando...</p>');
        $('#wpss_export').hide();

        const folder = $('input[name=folder]:checked').val();

        // Tomar plugins excluidos
        let exclude_plugins = [];
        $('input[name="exclude_plugins[]"]:checked').each(function(){
            exclude_plugins.push($(this).val());
        });

        
        $.post(wpss_ajax.ajax_url, {
            action:'wpss_scan', 
            folder: folder,
            exclude_plugins: exclude_plugins
        }, function(data){
            if($.isEmptyObject(data)){
                $('#wpss_results').html('<p>No se encontraron archivos sospechosos.</p>');
                return;
            }

            let html = '<table class="wp-list-table widefat fixed striped"><thead><tr>'+
                       '<th>Archivo</th><th>Potencial Peligro</th><th>Última Modificación</th></tr></thead><tbody>';
            let csv = 'Archivo,Funciones,Última Modificación\n';

            data.forEach(item => {
                let funcHtml = '';
                item.flags.forEach(f => {
                    funcHtml += '<span style="padding:3px 8px; margin:2px; border-radius:5px; display:inline-block;background-color:'+colors[f]+'">'+f+'</span> ';
                });

                html += '<tr><td>'+item.file+'</td><td>'+funcHtml+'</td><td>'+item.modified+'</td></tr>';

                csv += '"'+item.file+'","'+item.flags.join(',')+'","'+item.modified+'"\n';
            });

            html += '</tbody></table>';
            $('#wpss_results').html(html);

            // Guardar CSV temporal
            $('#wpss_export').data('csv', csv).show();
        });
    });

    $('#wpss_export').click(function(){
        const csv = $(this).data('csv');
        const blob = new Blob([csv], {type: 'text/csv'});
        const url = URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = 'wp-scan-security.csv';
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    });

    
    // Mostrar exclusión de plugins solo si se selecciona wp-content o all
    const radios = document.querySelectorAll('input[name="folder"]');
    const pluginsDiv = document.getElementById('wpss_plugins_exclude');
    
    radios.forEach(radio => {
        radio.addEventListener('change', function() {
            if (this.value === 'wp-content' || this.value === 'all') {
                pluginsDiv.style.display = 'block';
            } else {
                pluginsDiv.style.display = 'none';
            }
        });
    });
});